---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-next upgrade

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし。全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/cli/next-upgrade.ts` - next upgradeコマンドの実装（41行）
- E-02: `packages/next/src/bin/next.ts` - CLIエントリーポイント（466-493行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NextUpgradeOptionsはrevisionとverboseの2プロパティ | E-01 (5-8行目) | ○ |
| C-02 | getProjectDirでプロジェクトディレクトリ解決 | E-01 (14行目) | ○ |
| C-03 | getNpxCommandでnpxコマンド取得 | E-01 (15-16行目) | ○ |
| C-04 | @next/codemod@canaryを常に使用 | E-01 (21行目) | ○ |
| C-05 | upgradeサブコマンドを実行 | E-01 (22行目) | ○ |
| C-06 | --verbose時にフラグ追加 | E-01 (25-27行目) | ○ |
| C-07 | spawnでstdio: 'inherit' | E-01 (33行目) | ○ |
| C-08 | cwd: baseDirを設定 | E-01 (34行目) | ○ |
| C-09 | closeイベントでprocess.exitCodeを設定 | E-01 (38-40行目) | ○ |
| C-10 | process.exit()ではなくprocess.exitCodeを使用 | E-01 (39行目) | ○ |
| C-11 | canaryバージョンではデフォルトrevision='canary' | E-02 (481行目) | ○ |
| C-12 | rcバージョンではデフォルトrevision='rc' | E-02 (483行目) | ○ |
| C-13 | betaバージョンではデフォルトrevision='beta' | E-02 (485行目) | ○ |
| C-14 | その他ではデフォルトrevision='latest' | E-02 (487行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。本機能は非常にシンプルなラッパーであり、全主張の根拠が確認できている。

## 5) リスクフラグ（レビュー観点）
- 0: @next/codemodの実際のupgradeロジックは外部パッケージに委譲されており、本設計書のスコープ外
- 0: getNpxCommandの実装詳細は未確認だが、本機能の動作に直接影響しない

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトrevisionの決定ロジック（canary/rc/beta/latest）が正しいか
- [ ] @next/codemod@canaryの使用理由が適切に説明されているか
- [ ] process.exitCodeとprocess.exit()の違いが正確か
- [ ] spawn引数が正確に記述されているか
